<?php

/**
 * Implements hook_admin_settings() for module settings configuration.
 */
function justmailto_integration_admin_settings_form($form_state) {
	$form['justmailto_integration_code'] = array(
		'#title' => t('JustMailto Integration Code'),
		'#type' => 'textarea',
		'#default_value' => variable_get('justmailto_integration_code', ''),
		'#description' => t('This is the integration code provided after creating a box on the JustMailto website. If you do not have a JustMailto account, <a href="@jmtregister" target="_blank">you can go create one now</a>, and come back here when you are ready!', array('@jmtregister' => 'http://www.justmailto.com/signup')),
	);

	return system_settings_form($form);
}


/**
 * Implements _form_validate().
 */
function justmailto_integration_admin_settings_form_validate($form, &$form_state) {
	if ($form_state['values']['justmailto_integration_code']) {
		$matches = array();
		preg_match_all("/src\s*=\s*\"(.+?)\"/", $form_state['values']['justmailto_integration_code'], $matches);
		$integrationscripts = $matches[1];
		variable_set('justmailto_integrations_scripts', $integrationscripts);
	}
}



