<?php

function jmt_admin_menu() {
	add_options_page('JustMailto Settings', 'JustMailto', 'manage_options', 'jmt-settings-page', 'jmt_settings_page');

	add_action('admin_init', 'register_jmt_settings');
}

function register_jmt_settings() {
	//register our settings
	register_setting( 'jmt-settings-group', 'jmt_int_code' );
}

function jmt_settings_page() {
	if (!current_user_can('manage_options'))  {
		wp_die(__( 'You do not have sufficient permissions to access this page.'));
	}
	?>
	<div class="wrap">
	<h2 style="vertical-align: top;line-height: 41px;"><img src="<?php echo plugins_url( 'img/logo-small.png' , __FILE__ ); ?>"> Settings</h2>

	<form method="post" action="options.php">
		<?php settings_fields('jmt-settings-group'); ?>
		<?php do_settings_sections('jmt-settings-page'); ?>
		<table class="form-table">
			<tr>
			<td colspan="2">
				<p>You can find your JMT integration code on your box's Integration page.</p>
			</td>
			</tr>

			<tr valign="top">
			<th scope="row">JMT Integration Code:</th>
			<td><textarea cols="80" name="jmt_int_code"><?php echo get_option('jmt_int_code'); ?></textarea></td>
			</tr>
		</table>

		<?php submit_button(); ?>

	</form>
	</div>
	<?php
}






add_action('admin_menu', 'jmt_admin_menu');